/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.lobby.Lobby;
import de.jcm.discordgamesdk.lobby.LobbyMemberTransaction;
import de.jcm.discordgamesdk.lobby.LobbySearchQuery;
import de.jcm.discordgamesdk.lobby.LobbyTransaction;
import de.jcm.discordgamesdk.user.DiscordUser;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LobbyManager {
    private final long pointer;
    private final Core core;

    LobbyManager(long l, Core core) {
        this.pointer = l;
        this.core = core;
    }

    public LobbyTransaction getLobbyCreateTransaction() {
        Object object = this.core.execute(() -> this.getLobbyCreateTransaction(this.pointer));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (LobbyTransaction)object;
    }

    public LobbyTransaction getLobbyUpdateTransaction(long l) {
        Object object = this.core.execute(() -> this.getLobbyUpdateTransaction(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (LobbyTransaction)object;
    }

    public LobbyTransaction getLobbyUpdateTransaction(Lobby lobby) {
        return this.getLobbyUpdateTransaction(lobby.getId());
    }

    public LobbyMemberTransaction getMemberUpdateTransaction(long l, long l2) {
        Object object = this.core.execute(() -> this.getMemberUpdateTransaction(this.pointer, l, l2));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (LobbyMemberTransaction)object;
    }

    public LobbyMemberTransaction getMemberUpdateTransaction(Lobby lobby, long l) {
        return this.getMemberUpdateTransaction(lobby.getId(), l);
    }

    public void createLobby(LobbyTransaction lobbyTransaction, BiConsumer<Result, Lobby> biConsumer) {
        this.core.execute(() -> this.createLobby(this.pointer, lobbyTransaction.getPointer(), Objects.requireNonNull(biConsumer)));
    }

    public void createLobby(LobbyTransaction lobbyTransaction, Consumer<Lobby> consumer) {
        this.createLobby(lobbyTransaction, (Result result, Lobby lobby) -> {
            Core.DEFAULT_CALLBACK.accept((Result)((Object)result));
            consumer.accept((Lobby)lobby);
        });
    }

    public void updateLobby(long l, LobbyTransaction lobbyTransaction, Consumer<Result> consumer) {
        this.core.execute(() -> this.updateLobby(this.pointer, l, lobbyTransaction.getPointer(), Objects.requireNonNull(consumer)));
    }

    public void updateLobby(long l, LobbyTransaction lobbyTransaction) {
        this.updateLobby(l, lobbyTransaction, Core.DEFAULT_CALLBACK);
    }

    public void updateLobby(Lobby lobby, LobbyTransaction lobbyTransaction, Consumer<Result> consumer) {
        this.updateLobby(lobby.getId(), lobbyTransaction, consumer);
    }

    public void updateLobby(Lobby lobby, LobbyTransaction lobbyTransaction) {
        this.updateLobby(lobby, lobbyTransaction, Core.DEFAULT_CALLBACK);
    }

    public void deleteLobby(long l, Consumer<Result> consumer) {
        this.core.execute(() -> this.deleteLobby(this.pointer, l, Objects.requireNonNull(consumer)));
    }

    public void deleteLobby(long l) {
        this.deleteLobby(l, Core.DEFAULT_CALLBACK);
    }

    public void deleteLobby(Lobby lobby, Consumer<Result> consumer) {
        this.deleteLobby(lobby.getId(), consumer);
    }

    public void deleteLobby(Lobby lobby) {
        this.deleteLobby(lobby, Core.DEFAULT_CALLBACK);
    }

    public void connectLobby(long l, String string, BiConsumer<Result, Lobby> biConsumer) {
        if (string.getBytes().length >= 128) {
            throw new IllegalArgumentException("max secret length is 127");
        }
        this.core.execute(() -> this.connectLobby(this.pointer, l, string, Objects.requireNonNull(biConsumer)));
    }

    public void connectLobby(long l, String string, Consumer<Lobby> consumer) {
        this.connectLobby(l, string, (Result result, Lobby lobby) -> {
            Core.DEFAULT_CALLBACK.accept((Result)((Object)result));
            consumer.accept((Lobby)lobby);
        });
    }

    public void connectLobby(Lobby lobby, BiConsumer<Result, Lobby> biConsumer) {
        this.connectLobby(lobby.getId(), lobby.getSecret(), biConsumer);
    }

    public void connectLobbyWithActivitySecret(String string, BiConsumer<Result, Lobby> biConsumer) {
        if (string.getBytes().length >= 128) {
            throw new IllegalArgumentException("max activity secret length is 127");
        }
        this.core.execute(() -> this.connectLobbyWithActivitySecret(this.pointer, string, Objects.requireNonNull(biConsumer)));
    }

    public void connectLobbyWithActivitySecret(String string, Consumer<Lobby> consumer) {
        this.connectLobbyWithActivitySecret(string, (Result result, Lobby lobby) -> {
            Core.DEFAULT_CALLBACK.accept((Result)((Object)result));
            consumer.accept((Lobby)lobby);
        });
    }

    public void disconnectLobby(long l, Consumer<Result> consumer) {
        this.core.execute(() -> this.disconnectLobby(this.pointer, l, Objects.requireNonNull(consumer)));
    }

    public void disconnectLobby(long l) {
        this.disconnectLobby(l, Core.DEFAULT_CALLBACK);
    }

    public void disconnectLobby(Lobby lobby, Consumer<Result> consumer) {
        this.disconnectLobby(lobby.getId(), consumer);
    }

    public void disconnectLobby(Lobby lobby) {
        this.disconnectLobby(lobby, Core.DEFAULT_CALLBACK);
    }

    public Lobby getLobby(long l) {
        Object object = this.core.execute(() -> this.getLobby(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Lobby)object;
    }

    public String getLobbyActivitySecret(long l) {
        Object object = this.core.execute(() -> this.getLobbyActivitySecret(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (String)object;
    }

    public String getLobbyActivitySecret(Lobby lobby) {
        return this.getLobbyActivitySecret(lobby.getId());
    }

    public String getLobbyMetadataValue(long l, String string) {
        if (string.getBytes().length >= 256) {
            throw new IllegalArgumentException("max key length is 255");
        }
        Object object = this.core.execute(() -> this.getLobbyMetadataValue(this.pointer, l, string));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (String)object;
    }

    public String getLobbyMetadataValue(Lobby lobby, String string) {
        return this.getLobbyMetadataValue(lobby.getId(), string);
    }

    public String getLobbyMetadataKey(long l, int n) {
        Object object = this.core.execute(() -> this.getLobbyMetadataKey(this.pointer, l, n));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (String)object;
    }

    public String getLobbyMetadataKey(Lobby lobby, int n) {
        return this.getLobbyMetadataKey(lobby.getId(), n);
    }

    public int lobbyMetadataCount(long l) {
        Object object = this.core.execute(() -> this.lobbyMetadataCount(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Integer)object;
    }

    public int lobbyMetadataCount(Lobby lobby) {
        return this.lobbyMetadataCount(lobby.getId());
    }

    public Map<String, String> getLobbyMetadata(long l) {
        int n = this.lobbyMetadataCount(l);
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.getLobbyMetadataKey(l, i);
            String string2 = this.getLobbyMetadataValue(l, string);
            hashMap.put(string, string2);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Map<String, String> getLobbyMetadata(Lobby lobby) {
        return this.getLobbyMetadata(lobby.getId());
    }

    public int memberCount(long l) {
        Object object = this.core.execute(() -> this.memberCount(this.pointer, l));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Integer)object;
    }

    public int memberCount(Lobby lobby) {
        return this.memberCount(lobby.getId());
    }

    public long getMemberUserId(long l, int n) {
        Object object = this.core.execute(() -> this.getMemberUserId(this.pointer, l, n));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Long)object;
    }

    public long getMemberUserId(Lobby lobby, int n) {
        return this.getMemberUserId(lobby.getId(), n);
    }

    public List<Long> getMemberUserIds(long l) {
        List list = IntStream.range(0, this.memberCount(l)).mapToLong(n -> this.getMemberUserId(l, n)).boxed().collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public List<Long> getMemberUserIds(Lobby lobby) {
        return this.getMemberUserIds(lobby.getId());
    }

    public DiscordUser getMemberUser(long l, long l2) {
        Object object = this.core.execute(() -> this.getMemberUser(this.pointer, l, l2));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (DiscordUser)object;
    }

    public DiscordUser getMemberUser(Lobby lobby, long l) {
        return this.getMemberUser(lobby.getId(), l);
    }

    public List<DiscordUser> getMemberUsers(long l) {
        List list = this.getMemberUserIds(l).stream().map(l2 -> this.getMemberUser(l, (long)l2)).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public List<DiscordUser> getMemberUsers(Lobby lobby) {
        return this.getMemberUsers(lobby.getId());
    }

    public String getMemberMetadataValue(long l, long l2, String string) {
        if (string.getBytes().length >= 256) {
            throw new IllegalArgumentException("max key length is 255");
        }
        Object object = this.core.execute(() -> this.getMemberMetadataValue(this.pointer, l, l2, string));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (String)object;
    }

    public String getMemberMetadataValue(Lobby lobby, long l, String string) {
        return this.getMemberMetadataValue(lobby.getId(), l, string);
    }

    public String getMemberMetadataKey(long l, long l2, int n) {
        Object object = this.core.execute(() -> this.getMemberMetadataKey(this.pointer, l, l2, n));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (String)object;
    }

    public String getMemberMetadataKey(Lobby lobby, long l, int n) {
        return this.getMemberMetadataKey(lobby.getId(), l, n);
    }

    public int memberMetadataCount(long l, long l2) {
        Object object = this.core.execute(() -> this.memberMetadataCount(this.pointer, l, l2));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Integer)object;
    }

    public int memberMetadataCount(Lobby lobby, long l) {
        return this.memberMetadataCount(lobby.getId(), l);
    }

    public Map<String, String> getMemberMetadata(long l, long l2) {
        int n = this.memberMetadataCount(l, l2);
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.getMemberMetadataKey(l, l2, i);
            String string2 = this.getMemberMetadataValue(l, l2, string);
            hashMap.put(string, string2);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Map<String, String> getMemberMetadata(Lobby lobby, long l) {
        return this.getMemberMetadata(lobby.getId(), l);
    }

    public void updateMember(long l, long l2, LobbyMemberTransaction lobbyMemberTransaction, Consumer<Result> consumer) {
        this.core.execute(() -> this.updateMember(this.pointer, l, l2, lobbyMemberTransaction.getPointer(), Objects.requireNonNull(consumer)));
    }

    public void updateMember(long l, long l2, LobbyMemberTransaction lobbyMemberTransaction) {
        this.updateMember(l, l2, lobbyMemberTransaction, Core.DEFAULT_CALLBACK);
    }

    public void updateMember(Lobby lobby, long l, LobbyMemberTransaction lobbyMemberTransaction, Consumer<Result> consumer) {
        this.updateMember(lobby.getId(), l, lobbyMemberTransaction, consumer);
    }

    public void updateMember(Lobby lobby, long l, LobbyMemberTransaction lobbyMemberTransaction) {
        this.updateMember(lobby, l, lobbyMemberTransaction, Core.DEFAULT_CALLBACK);
    }

    public void sendLobbyMessage(long l, byte[] byArray, Consumer<Result> consumer) {
        this.core.execute(() -> this.sendLobbyMessage(this.pointer, l, byArray, 0, byArray.length, Objects.requireNonNull(consumer)));
    }

    public void sendLobbyMessage(long l, byte[] byArray) {
        this.sendLobbyMessage(l, byArray, Core.DEFAULT_CALLBACK);
    }

    public void sendLobbyMessage(Lobby lobby, byte[] byArray, Consumer<Result> consumer) {
        this.sendLobbyMessage(lobby.getId(), byArray, consumer);
    }

    public void sendLobbyMessage(Lobby lobby, byte[] byArray) {
        this.sendLobbyMessage(lobby, byArray, Core.DEFAULT_CALLBACK);
    }

    public LobbySearchQuery getSearchQuery() {
        Object object = this.core.execute(() -> this.getSearchQuery(this.pointer));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (LobbySearchQuery)object;
    }

    public void search(LobbySearchQuery lobbySearchQuery, Consumer<Result> consumer) {
        this.core.execute(() -> this.search(this.pointer, lobbySearchQuery.getPointer(), Objects.requireNonNull(consumer)));
    }

    public void search(LobbySearchQuery lobbySearchQuery) {
        this.search(lobbySearchQuery, Core.DEFAULT_CALLBACK);
    }

    public int lobbyCount() {
        return this.core.execute(() -> this.lobbyCount(this.pointer));
    }

    public long getLobbyId(int n) {
        Object object = this.core.execute(() -> this.getLobbyId(this.pointer, n));
        if (object instanceof Result) {
            throw new GameSDKException((Result)((Object)object));
        }
        return (Long)object;
    }

    public List<Long> getLobbyIds() {
        List list = IntStream.range(0, this.lobbyCount()).mapToLong(this::getLobbyId).boxed().collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public List<Lobby> getLobbies() {
        List list = this.getLobbyIds().stream().map(this::getLobby).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }

    public void connectVoice(long l, Consumer<Result> consumer) {
        this.core.execute(() -> this.connectVoice(this.pointer, l, Objects.requireNonNull(consumer)));
    }

    public void connectVoice(long l) {
        this.connectVoice(l, Core.DEFAULT_CALLBACK);
    }

    public void connectVoice(Lobby lobby, Consumer<Result> consumer) {
        this.connectVoice(lobby.getId(), consumer);
    }

    public void connectVoice(Lobby lobby) {
        this.connectVoice(lobby, Core.DEFAULT_CALLBACK);
    }

    public void disconnectVoice(long l, Consumer<Result> consumer) {
        this.core.execute(() -> this.disconnectVoice(this.pointer, l, Objects.requireNonNull(consumer)));
    }

    public void disconnectVoice(long l) {
        this.disconnectVoice(l, Core.DEFAULT_CALLBACK);
    }

    public void disconnectVoice(Lobby lobby, Consumer<Result> consumer) {
        this.disconnectVoice(lobby.getId(), consumer);
    }

    public void disconnectVoice(Lobby lobby) {
        this.disconnectVoice(lobby, Core.DEFAULT_CALLBACK);
    }

    public void connectNetwork(long l) {
        Result result = this.core.execute(() -> this.connectNetwork(this.pointer, l));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void connectNetwork(Lobby lobby) {
        this.connectNetwork(lobby.getId());
    }

    public void disconnectNetwork(long l) {
        Result result = this.core.execute(() -> this.disconnectNetwork(this.pointer, l));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void disconnectNetwork(Lobby lobby) {
        this.disconnectNetwork(lobby.getId());
    }

    public void flushNetwork() {
        Result result = this.core.execute(() -> this.flushNetwork(this.pointer));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void openNetworkChannel(long l, byte by, boolean bl) {
        Result result = this.core.execute(() -> this.openNetworkChannel(this.pointer, l, by, bl));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void openNetworkChannel(Lobby lobby, byte by, boolean bl) {
        this.openNetworkChannel(lobby.getId(), by, bl);
    }

    public void sendNetworkMessage(long l, long l2, byte by, byte[] byArray) {
        Result result = this.core.execute(() -> this.sendNetworkMessage(this.pointer, l, l2, by, byArray, 0, byArray.length));
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void sendNetworkMessage(Lobby lobby, long l, byte by, byte[] byArray) {
        this.sendNetworkMessage(lobby.getId(), l, by, byArray);
    }

    private native Object getLobbyCreateTransaction(long var1);

    private native Object getLobbyUpdateTransaction(long var1, long var3);

    private native Object getMemberUpdateTransaction(long var1, long var3, long var5);

    private native void createLobby(long var1, long var3, BiConsumer<Result, Lobby> var5);

    private native void updateLobby(long var1, long var3, long var5, Consumer<Result> var7);

    private native void deleteLobby(long var1, long var3, Consumer<Result> var5);

    private native void connectLobby(long var1, long var3, String var5, BiConsumer<Result, Lobby> var6);

    private native void connectLobbyWithActivitySecret(long var1, String var3, BiConsumer<Result, Lobby> var4);

    private native void disconnectLobby(long var1, long var3, Consumer<Result> var5);

    private native Object getLobby(long var1, long var3);

    private native Object getLobbyActivitySecret(long var1, long var3);

    private native Object getLobbyMetadataValue(long var1, long var3, String var5);

    private native Object getLobbyMetadataKey(long var1, long var3, int var5);

    private native Object lobbyMetadataCount(long var1, long var3);

    private native Object memberCount(long var1, long var3);

    private native Object getMemberUserId(long var1, long var3, int var5);

    private native Object getMemberUser(long var1, long var3, long var5);

    private native Object getMemberMetadataValue(long var1, long var3, long var5, String var7);

    private native Object getMemberMetadataKey(long var1, long var3, long var5, int var7);

    private native Object memberMetadataCount(long var1, long var3, long var5);

    private native void updateMember(long var1, long var3, long var5, long var7, Consumer<Result> var9);

    private native void sendLobbyMessage(long var1, long var3, byte[] var5, int var6, int var7, Consumer<Result> var8);

    private native Object getSearchQuery(long var1);

    private native void search(long var1, long var3, Consumer<Result> var5);

    private native int lobbyCount(long var1);

    private native Object getLobbyId(long var1, int var3);

    private native void connectVoice(long var1, long var3, Consumer<Result> var5);

    private native void disconnectVoice(long var1, long var3, Consumer<Result> var5);

    private native Result connectNetwork(long var1, long var3);

    private native Result disconnectNetwork(long var1, long var3);

    private native Result flushNetwork(long var1);

    private native Result openNetworkChannel(long var1, long var3, byte var5, boolean var6);

    private native Result sendNetworkMessage(long var1, long var3, long var5, byte var7, byte[] var8, int var9, int var10);
}

