/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk;

import de.jcm.discordgamesdk.Core;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.activity.ActivityActionType;
import java.util.Objects;
import java.util.function.Consumer;

public class OverlayManager {
    private final long pointer;
    private final Core core;

    OverlayManager(long l, Core core) {
        this.pointer = l;
        this.core = core;
    }

    public boolean isEnabled() {
        return this.core.execute(() -> this.isEnabled(this.pointer));
    }

    public boolean isLocked() {
        return this.core.execute(() -> this.isLocked(this.pointer));
    }

    public void setLocked(boolean bl) {
        this.setLocked(bl, Core.DEFAULT_CALLBACK);
    }

    public void setLocked(boolean bl, Consumer<Result> consumer) {
        this.core.execute(() -> this.setLocked(this.pointer, bl, Objects.requireNonNull(consumer)));
    }

    public void openActivityInvite(ActivityActionType activityActionType) {
        this.openActivityInvite(activityActionType, Core.DEFAULT_CALLBACK);
    }

    public void openActivityInvite(ActivityActionType activityActionType, Consumer<Result> consumer) {
        this.core.execute(() -> this.openActivityInvite(this.pointer, activityActionType.ordinal(), Objects.requireNonNull(consumer)));
    }

    public void openGuildInvite(String string) {
        this.openGuildInvite(string, Core.DEFAULT_CALLBACK);
    }

    public void openGuildInvite(String string, Consumer<Result> consumer) {
        this.core.execute(() -> this.openGuildInvite(this.pointer, string, Objects.requireNonNull(consumer)));
    }

    public void openVoiceSettings() {
        this.openVoiceSettings(Core.DEFAULT_CALLBACK);
    }

    public void openVoiceSettings(Consumer<Result> consumer) {
        this.core.execute(() -> this.openVoiceSettings(this.pointer, Objects.requireNonNull(consumer)));
    }

    private native boolean isEnabled(long var1);

    private native boolean isLocked(long var1);

    private native void setLocked(long var1, boolean var3, Consumer<Result> var4);

    private native void openActivityInvite(long var1, int var3, Consumer<Result> var4);

    private native void openGuildInvite(long var1, String var3, Consumer<Result> var4);

    private native void openVoiceSettings(long var1, Consumer<Result> var3);
}

