/*
 * Decompiled with CFR 0.152.
 */
package de.jcm.discordgamesdk.lobby;

import de.jcm.discordgamesdk.GameSDKException;
import de.jcm.discordgamesdk.Result;
import de.jcm.discordgamesdk.lobby.LobbyType;

public class LobbyTransaction {
    private final long pointer;

    LobbyTransaction(long l) {
        this.pointer = l;
    }

    public long getPointer() {
        return this.pointer;
    }

    public void setType(LobbyType lobbyType) {
        Result result = this.setType(this.pointer, lobbyType.ordinal() + 1);
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void setOwner(long l) {
        Result result = this.setOwner(this.pointer, l);
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void setCapacity(int n) {
        Result result = this.setCapacity(this.pointer, n);
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void setMetadata(String string, String string2) {
        if (string.getBytes().length >= 256) {
            throw new IllegalArgumentException("max key length is 255");
        }
        if (string2.getBytes().length >= 4096) {
            throw new IllegalArgumentException("max value length is 4095");
        }
        Result result = this.setMetadata(this.pointer, string, string2);
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void deleteMetadata(String string) {
        if (string.getBytes().length >= 256) {
            throw new IllegalArgumentException("max key length is 255");
        }
        Result result = this.deleteMetadata(this.pointer, string);
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    public void setLocked(boolean bl) {
        Result result = this.setLocked(this.pointer, bl);
        if (result != Result.OK) {
            throw new GameSDKException(result);
        }
    }

    private native Result setType(long var1, int var3);

    private native Result setOwner(long var1, long var3);

    private native Result setCapacity(long var1, int var3);

    private native Result setMetadata(long var1, String var3, String var4);

    private native Result deleteMetadata(long var1, String var3);

    private native Result setLocked(long var1, boolean var3);
}

