/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObject;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectAggregator;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpServerUpgradeHandler$SourceCodec;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeCodec;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeCodecFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeEvent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.util.AsciiString;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class HttpServerUpgradeHandler
extends HttpObjectAggregator {
    private final HttpServerUpgradeHandler$SourceCodec sourceCodec;
    private final HttpServerUpgradeHandler$UpgradeCodecFactory upgradeCodecFactory;
    private final boolean validateHeaders;
    private boolean handlingUpgrade;

    public HttpServerUpgradeHandler(HttpServerUpgradeHandler$SourceCodec httpServerUpgradeHandler$SourceCodec, HttpServerUpgradeHandler$UpgradeCodecFactory httpServerUpgradeHandler$UpgradeCodecFactory) {
        this(httpServerUpgradeHandler$SourceCodec, httpServerUpgradeHandler$UpgradeCodecFactory, 0);
    }

    public HttpServerUpgradeHandler(HttpServerUpgradeHandler$SourceCodec httpServerUpgradeHandler$SourceCodec, HttpServerUpgradeHandler$UpgradeCodecFactory httpServerUpgradeHandler$UpgradeCodecFactory, int n) {
        this(httpServerUpgradeHandler$SourceCodec, httpServerUpgradeHandler$UpgradeCodecFactory, n, true);
    }

    public HttpServerUpgradeHandler(HttpServerUpgradeHandler$SourceCodec httpServerUpgradeHandler$SourceCodec, HttpServerUpgradeHandler$UpgradeCodecFactory httpServerUpgradeHandler$UpgradeCodecFactory, int n, boolean bl) {
        super(n);
        this.sourceCodec = ObjectUtil.checkNotNull(httpServerUpgradeHandler$SourceCodec, "sourceCodec");
        this.upgradeCodecFactory = ObjectUtil.checkNotNull(httpServerUpgradeHandler$UpgradeCodecFactory, "upgradeCodecFactory");
        this.validateHeaders = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        HttpRequest httpRequest;
        if (!this.handlingUpgrade) {
            if (!(httpObject instanceof HttpRequest)) {
                ReferenceCountUtil.retain(httpObject);
                channelHandlerContext.fireChannelRead(httpObject);
                return;
            }
            httpRequest = (HttpRequest)httpObject;
            if (httpRequest.headers().contains(HttpHeaderNames.UPGRADE) && this.shouldHandleUpgradeRequest(httpRequest)) {
                this.handlingUpgrade = true;
            } else {
                ReferenceCountUtil.retain(httpObject);
                channelHandlerContext.fireChannelRead(httpObject);
                return;
            }
        }
        if (httpObject instanceof FullHttpRequest) {
            httpRequest = (FullHttpRequest)httpObject;
            ReferenceCountUtil.retain(httpObject);
            list.add(httpObject);
        } else {
            super.decode(channelHandlerContext, httpObject, list);
            if (list.isEmpty()) {
                return;
            }
            assert (list.size() == 1);
            this.handlingUpgrade = false;
            httpRequest = (FullHttpRequest)list.get(0);
        }
        if (this.upgrade(channelHandlerContext, (FullHttpRequest)httpRequest)) {
            list.clear();
        }
    }

    protected boolean shouldHandleUpgradeRequest(HttpRequest httpRequest) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgrade(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) {
        Object object;
        Object object3;
        CharSequence charSequence;
        List<CharSequence> list = HttpServerUpgradeHandler.splitHeader(fullHttpRequest.headers().get(HttpHeaderNames.UPGRADE));
        int n = list.size();
        HttpServerUpgradeHandler$UpgradeCodec httpServerUpgradeHandler$UpgradeCodec = null;
        CharSequence charSequence2 = null;
        for (int i = 0; i < n; ++i) {
            charSequence = list.get(i);
            object3 = this.upgradeCodecFactory.newUpgradeCodec(charSequence);
            if (object3 == null) continue;
            charSequence2 = charSequence;
            httpServerUpgradeHandler$UpgradeCodec = object3;
            break;
        }
        if (httpServerUpgradeHandler$UpgradeCodec == null) {
            return false;
        }
        List<String> list2 = fullHttpRequest.headers().getAll(HttpHeaderNames.CONNECTION);
        if (list2 == null || list2.isEmpty()) {
            return false;
        }
        charSequence = new StringBuilder(list2.size() * 10);
        for (CharSequence object22 : list2) {
            ((StringBuilder)charSequence).append(object22).append(',');
        }
        ((StringBuilder)charSequence).setLength(((StringBuilder)charSequence).length() - 1);
        object3 = httpServerUpgradeHandler$UpgradeCodec.requiredUpgradeHeaders();
        List<CharSequence> list3 = HttpServerUpgradeHandler.splitHeader(charSequence);
        if (!AsciiString.containsContentEqualsIgnoreCase(list3, HttpHeaderNames.UPGRADE) || !AsciiString.containsAllContentEqualsIgnoreCase(list3, object3)) {
            return false;
        }
        Object object2 = object3.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (fullHttpRequest.headers().contains((CharSequence)object)) continue;
            return false;
        }
        object2 = this.createUpgradeResponse(charSequence2);
        if (!httpServerUpgradeHandler$UpgradeCodec.prepareUpgradeResponse(channelHandlerContext, fullHttpRequest, object2.headers())) {
            return false;
        }
        object = new HttpServerUpgradeHandler$UpgradeEvent(charSequence2, fullHttpRequest);
        try {
            ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(object2);
            this.sourceCodec.upgradeFrom(channelHandlerContext);
            httpServerUpgradeHandler$UpgradeCodec.upgradeTo(channelHandlerContext, fullHttpRequest);
            channelHandlerContext.pipeline().remove(this);
            channelHandlerContext.fireUserEventTriggered(((HttpServerUpgradeHandler$UpgradeEvent)object).retain());
            channelFuture.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            ((HttpServerUpgradeHandler$UpgradeEvent)object).release();
        }
        return true;
    }

    private FullHttpResponse createUpgradeResponse(CharSequence charSequence) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, this.validateHeaders);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)charSequence);
        return defaultFullHttpResponse;
    }

    private static List<CharSequence> splitHeader(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(4);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }
}

