/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.spdy;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.MessageToMessageCodec;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyHttpHeaders$Names;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<Object, HttpMessage> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new ArrayDeque<Integer>();

    @Override
    public boolean acceptInboundMessage(Object object) {
        return object instanceof HttpMessage || object instanceof SpdyRstStreamFrame;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage, List<Object> list) {
        Integer n = this.ids.poll();
        if (n != null && n.intValue() != NO_ID.intValue() && !httpMessage.headers().contains(SpdyHttpHeaders$Names.STREAM_ID)) {
            httpMessage.headers().setInt(SpdyHttpHeaders$Names.STREAM_ID, n);
        }
        list.add(ReferenceCountUtil.retain(httpMessage));
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) {
        if (object instanceof HttpMessage) {
            boolean bl = ((HttpMessage)object).headers().contains(SpdyHttpHeaders$Names.STREAM_ID);
            if (!bl) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(((HttpMessage)object).headers().getInt(SpdyHttpHeaders$Names.STREAM_ID));
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)object).streamId());
        }
        list.add(ReferenceCountUtil.retain(object));
    }
}

