/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import pro.gravit.repackage.io.netty.handler.ssl.JdkAlpnSslEngine$1;
import pro.gravit.repackage.io.netty.handler.ssl.JdkAlpnSslEngine$2;
import pro.gravit.repackage.io.netty.handler.ssl.JdkAlpnSslEngine$AlpnSelector;
import pro.gravit.repackage.io.netty.handler.ssl.JdkAlpnSslUtils;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$ProtocolSelectionListener;
import pro.gravit.repackage.io.netty.handler.ssl.JdkSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.SslUtils;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

@SuppressJava6Requirement(reason="Usage guarded by java version check")
class JdkAlpnSslEngine
extends JdkSslEngine {
    private final JdkApplicationProtocolNegotiator$ProtocolSelectionListener selectionListener;
    private final JdkAlpnSslEngine$AlpnSelector alpnSelector;

    JdkAlpnSslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl, BiConsumer<SSLEngine, JdkAlpnSslEngine$AlpnSelector> biConsumer, BiConsumer<SSLEngine, List<String>> biConsumer2) {
        super(sSLEngine);
        if (bl) {
            this.selectionListener = null;
            this.alpnSelector = new JdkAlpnSslEngine$AlpnSelector(this, jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())));
            biConsumer.accept(sSLEngine, this.alpnSelector);
        } else {
            this.selectionListener = jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols());
            this.alpnSelector = null;
            biConsumer2.accept(sSLEngine, jdkApplicationProtocolNegotiator.protocols());
        }
    }

    JdkAlpnSslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl) {
        this(sSLEngine, jdkApplicationProtocolNegotiator, bl, new JdkAlpnSslEngine$1(), new JdkAlpnSslEngine$2());
    }

    private SSLEngineResult verifyProtocolSelection(SSLEngineResult sSLEngineResult) {
        if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (this.alpnSelector == null) {
                try {
                    String string = this.getApplicationProtocol();
                    assert (string != null);
                    if (string.isEmpty()) {
                        this.selectionListener.unsupported();
                    }
                    this.selectionListener.selected(string);
                }
                catch (Throwable throwable) {
                    throw SslUtils.toSSLHandshakeException(throwable);
                }
            } else {
                assert (this.selectionListener == null);
                this.alpnSelector.checkUnsupported();
            }
        }
        return sSLEngineResult;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return this.verifyProtocolSelection(super.wrap(byteBuffer, byteBuffer2));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) {
        return this.verifyProtocolSelection(super.wrap(byteBufferArray, byteBuffer));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) {
        return this.verifyProtocolSelection(super.wrap(byteBufferArray, n, n2, byteBuffer));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBuffer2));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) {
        return this.verifyProtocolSelection(super.unwrap(byteBuffer, byteBufferArray, n, n2));
    }

    @Override
    void setNegotiatedApplicationProtocol(String string) {
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        String string = this.getApplicationProtocol();
        if (string != null) {
            return string.isEmpty() ? null : string;
        }
        return null;
    }

    @Override
    public String getApplicationProtocol() {
        return JdkAlpnSslUtils.getApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocol(this.getWrappedEngine());
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> biFunction) {
        JdkAlpnSslUtils.setHandshakeApplicationProtocolSelector(this.getWrappedEngine(), biFunction);
    }

    @Override
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return JdkAlpnSslUtils.getHandshakeApplicationProtocolSelector(this.getWrappedEngine());
    }
}

